/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.loot.affix;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.deadly.loot.LootCategory;
import shadows.apotheosis.deadly.loot.LootRarity;
import shadows.placebo.config.Configuration;

public abstract class Affix
implements IForgeRegistryEntry<Affix> {
    public static ForgeRegistry<Affix> REGISTRY;
    public static Configuration config;
    protected ResourceLocation name;
    protected final LootRarity rarity;

    public Affix(LootRarity rarity) {
        this.rarity = rarity;
    }

    public void addModifiers(ItemStack stack, float level, EquipmentSlot type, BiConsumer<Attribute, AttributeModifier> map) {
    }

    public void addInformation(ItemStack stack, float level, Consumer<Component> list) {
        list.accept((Component)Affix.loreComponent("affix." + this.getRegistryName() + ".desc", Affix.fmt(level)));
    }

    public Component chainName(Component name, boolean prefix) {
        if (prefix) {
            return new TranslatableComponent("%s %s", new Object[]{new TranslatableComponent("affix." + this.name + ".prefix"), name});
        }
        return new TranslatableComponent("%s %s", new Object[]{name, new TranslatableComponent("affix." + this.name)});
    }

    public int getProtectionLevel(float level, DamageSource source) {
        return 0;
    }

    public float getExtraDamageFor(float level, MobType creatureType) {
        return 0.0f;
    }

    public void onEntityDamaged(LivingEntity user, @Nullable Entity target, float level) {
    }

    public void onUserHurt(LivingEntity user, @Nullable Entity attacker, float level) {
    }

    public void onArrowFired(LivingEntity user, AbstractArrow arrow, ItemStack bow, float level) {
    }

    @Nullable
    public InteractionResult onItemUse(UseOnContext ctx, float level) {
        return null;
    }

    public void onArrowImpact(AbstractArrow arrow, HitResult res, HitResult.Type type, float level) {
    }

    public float onShieldBlock(LivingEntity entity, ItemStack stack, DamageSource source, float amount, float level) {
        return amount;
    }

    public Affix setRegistryName(ResourceLocation name) {
        if (this.name == null) {
            this.name = name;
        }
        return this;
    }

    public Affix setRegistryName(String name) {
        return this.setRegistryName(GameData.checkPrefix((String)name, (boolean)false));
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<Affix> getRegistryType() {
        return Affix.class;
    }

    public static void classload() {
    }

    public String toString() {
        return String.format("Affix: %s", this.name);
    }

    public abstract boolean canApply(LootCategory var1);

    public static MutableComponent loreComponent(String text, Object ... args) {
        return new TranslatableComponent(text, args).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_PURPLE});
    }

    public static String fmt(float f) {
        if (f == (float)((long)f)) {
            return String.format("%d", (long)f);
        }
        return String.format("%.2f", Float.valueOf(f));
    }

    public Component getDisplayName(float level) {
        return new TranslatableComponent("affix." + this.getRegistryName() + ".name", new Object[]{Affix.fmt(level)}).m_130940_(ChatFormatting.GRAY);
    }

    public LootRarity getRarity() {
        return this.rarity;
    }
}

